<?php
/* --------------------------------------------------------------
 GoogleLoadLayoutDataHandler.php 2020-04-16
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2020 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

namespace GXModules\Gambio\Google\Admin\Plugin;

use Gambio\Admin\Layout\Smarty\LoadLayoutData;

/**
 * Class GoogleLoadLayoutDataHandler
 * @package GXModules\Gambio\Google\Admin
 */
class GoogleLoadLayoutDataHandler
{
    /**
     * @var GoogleFooterBadgeLoader
     */
    private $footerBadgeLoader;
    
    
    /**
     * GoogleLoadLayoutDataHandler constructor.
     *
     * @param GoogleFooterBadgeLoader $footerBadgeLoader
     */
    public function __construct(GoogleFooterBadgeLoader $footerBadgeLoader)
    {
        $this->footerBadgeLoader = $footerBadgeLoader;
    }
    
    
    /**
     * Adds the google footer badge loader.
     *
     * @param LoadLayoutData $command
     *
     * @return LoadLayoutData
     */
    public function __invoke(LoadLayoutData $command): LoadLayoutData
    {
        $command->addLoader($this->footerBadgeLoader);
        
        return $command;
    }
}